﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using TMPro;
using UnityEngine;
using UnityEngine.EventSystems;
using UnityEngine.Tilemaps;
using UnityEngine.UI;

public class BeginPhase : GamePhase
{
    public override void OnStartCurrentPhase()
    {
        //Disable the game updating and pausing, and setup the UI
        Time.timeScale = 0.0f;
        PauseMenu.CanPause = false;
        GameController.Instance.Timer.SetActive(false);
        GameController.Instance.HintUI.SetActive(false);
        GameController.Instance.ReadyScreen.SetActive(true);
        GameController.Instance.ReadyScreen.GetComponent<ReadyMenu>().MoveToThis(true);

        //Set the time for the hider
        MapScroller.PlayerObject = GameController.Instance.HiderPlayerObject;
        GameController.Instance.SetRoundTime(Constants.PlayerRole.Hider);

        //Spawn both players back at spawn, disable movement on both
        GameController.Instance.HiderPlayerObject.transform.position = new Vector3(1.0f, -0.05f, 0.0f);
        GameController.Instance.SeekerPlayerObject.transform.position = new Vector3(1.0f, -0.05f, 0.0f);
        GameController.Instance.SeekerPlayerObject.GetComponent<BasicMovement>().CanMove = false;
        GameController.Instance.HiderPlayerObject.GetComponent<BasicMovement>().CanMove = false;

        //We're beginning, so enable the hider and disable the seeker, update the role text
        GameController.Instance.HiderPlayerObject.SetActive(true);
        GameController.Instance.SeekerPlayerObject.SetActive(false);
        GameController.Instance.RoleText.text = "HIDER";
    }

    public override void Update()
    {
        
    }

    public override void OnEndCurrentPhase()
    {
        
    }
}
